package com.wissamfawaz;

import java.util.Arrays;
import java.util.PriorityQueue;

public class Main {
    public static void main(String[] args) {
        Point[] points = {
            new Point(0, 0), new Point(2, 2), new Point(1, 0), new Point(1, 1),
            new Point(1, 2)
        };

        System.out.println("Before: ");
        System.out.println(Arrays.toString(points));

        Point[] pointsSorted = pqSort(points);

        System.out.println("After: ");
        System.out.println(Arrays.toString(pointsSorted));
    }

    private static Point[] pqSort(Point[] points) {
        Point[] sortedPoints = new Point[points.length];
        PriorityQueue<Point> pq = new PriorityQueue<>(new PointsComparator());

        // Step#1: Insertion
        for(Point point : points) {
            pq.add(point); // pq.offer
        }

        // Step#2: Selection
        int idx = 0;

        while(!pq.isEmpty()) {
            sortedPoints[idx] = pq.remove();
            idx++;
        }

        return sortedPoints;
    }
    
}
